/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.registry.minecraft;

import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.ironchests.api.chesttype.ChestType;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlock;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.registry.custom.ChestTypeRegistry;
import tech.thatgravyboat.ironchests.common.registry.minecraft.forge.BlockRegistryImpl;

public class BlockRegistry {
    public static final ResourcefulRegistry<Block> BLOCKS = ResourcefulRegistries.create((Registry)Registry.f_122824_, (String)"ironchests");
    public static final ResourcefulRegistry<BlockEntityType<?>> BLOCK_ENTITIES = ResourcefulRegistries.create((Registry)Registry.f_122830_, (String)"ironchests");

    public static void init() {
        ChestTypeRegistry.INSTANCE.getChests().forEach(BlockRegistry::registerBoth);
        BLOCKS.init();
        BLOCK_ENTITIES.init();
    }

    private static void registerBoth(String id, ChestType type) {
        type.registries().setBlockSupplier((Supplier<GenericChestBlock>)BLOCKS.register(id, () -> GenericChestBlock.create(type, type.properties().getProperties())));
        type.registries().setBlockEntityType((Supplier<BlockEntityType<GenericChestBlockEntity>>)BLOCK_ENTITIES.register(id, () -> BlockRegistry.createBlockEntityType((pos, state) -> new GenericChestBlockEntity(pos, state, type), (Block)type.registries().getBlock().get())));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityFactory<E> factory, Block ... blocks) {
        void var1_1;
        return BlockRegistryImpl.createBlockEntityType(factory, (Block[])var1_1);
    }

    @FunctionalInterface
    public static interface BlockEntityFactory<T extends BlockEntity> {
        @NotNull
        public T create(BlockPos var1, BlockState var2);
    }
}

